package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.TStamp
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DeferredMaintenanceWindow(
    deferMaintenanceIdentifier: Option[String] = None,
    deferMaintenanceStartTime: Option[TStamp] = None,
    deferMaintenanceEndTime: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow = {
    import DeferredMaintenanceWindow.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
      .builder()
      .optionallyWith(
        deferMaintenanceIdentifier.map(value => value: java.lang.String)
      )(_.deferMaintenanceIdentifier)
      .optionallyWith(
        deferMaintenanceStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.deferMaintenanceStartTime)
      .optionallyWith(
        deferMaintenanceEndTime.map(value => TStamp.unwrap(value): Instant)
      )(_.deferMaintenanceEndTime)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly =
    zio.aws.redshift.model.DeferredMaintenanceWindow.wrap(buildAwsValue())
}
object DeferredMaintenanceWindow {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeferredMaintenanceWindow =
      zio.aws.redshift.model.DeferredMaintenanceWindow(
        deferMaintenanceIdentifier.map(value => value),
        deferMaintenanceStartTime.map(value => value),
        deferMaintenanceEndTime.map(value => value)
      )
    def deferMaintenanceIdentifier: Option[String]
    def deferMaintenanceStartTime: Option[TStamp]
    def deferMaintenanceEndTime: Option[TStamp]
    def getDeferMaintenanceIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "deferMaintenanceIdentifier",
        deferMaintenanceIdentifier
      )
    def getDeferMaintenanceStartTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("deferMaintenanceStartTime", deferMaintenanceStartTime)
    def getDeferMaintenanceEndTime: ZIO[Any, AwsError, TStamp] = AwsError
      .unwrapOptionField("deferMaintenanceEndTime", deferMaintenanceEndTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
  ) extends zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly {
    override val deferMaintenanceIdentifier: Option[String] = scala
      .Option(impl.deferMaintenanceIdentifier())
      .map(value => value: String)
    override val deferMaintenanceStartTime: Option[TStamp] = scala
      .Option(impl.deferMaintenanceStartTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val deferMaintenanceEndTime: Option[TStamp] = scala
      .Option(impl.deferMaintenanceEndTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow
  ): zio.aws.redshift.model.DeferredMaintenanceWindow.ReadOnly = new Wrapper(
    impl
  )
}
