package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VpcSecurityGroupMembership(
    vpcSecurityGroupId: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership = {
    import VpcSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership
      .builder()
      .optionallyWith(vpcSecurityGroupId.map(value => value: java.lang.String))(
        _.vpcSecurityGroupId
      )
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly =
    zio.aws.redshift.model.VpcSecurityGroupMembership.wrap(buildAwsValue())
}
object VpcSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.VpcSecurityGroupMembership =
      zio.aws.redshift.model.VpcSecurityGroupMembership(
        vpcSecurityGroupId.map(value => value),
        status.map(value => value)
      )
    def vpcSecurityGroupId: Option[String]
    def status: Option[String]
    def getVpcSecurityGroupId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcSecurityGroupId", vpcSecurityGroupId)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership
  ) extends zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly {
    override val vpcSecurityGroupId: Option[String] =
      scala.Option(impl.vpcSecurityGroupId()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership
  ): zio.aws.redshift.model.VpcSecurityGroupMembership.ReadOnly = new Wrapper(
    impl
  )
}
