package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeSnapshotCopyGrantsRequest(
    snapshotCopyGrantName: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None,
    tagKeys: Option[Iterable[String]] = None,
    tagValues: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest = {
    import DescribeSnapshotCopyGrantsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest
      .builder()
      .optionallyWith(
        snapshotCopyGrantName.map(value => value: java.lang.String)
      )(_.snapshotCopyGrantName)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        tagKeys.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagKeys)
      .optionallyWith(
        tagValues.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.tagValues)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeSnapshotCopyGrantsRequest.ReadOnly =
    zio.aws.redshift.model.DescribeSnapshotCopyGrantsRequest
      .wrap(buildAwsValue())
}
object DescribeSnapshotCopyGrantsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeSnapshotCopyGrantsRequest =
      zio.aws.redshift.model.DescribeSnapshotCopyGrantsRequest(
        snapshotCopyGrantName.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value),
        tagKeys.map(value => value),
        tagValues.map(value => value)
      )
    def snapshotCopyGrantName: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def tagKeys: Option[List[String]]
    def tagValues: Option[List[String]]
    def getSnapshotCopyGrantName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotCopyGrantName", snapshotCopyGrantName)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getTagKeys: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagKeys", tagKeys)
    def getTagValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("tagValues", tagValues)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest
  ) extends zio.aws.redshift.model.DescribeSnapshotCopyGrantsRequest.ReadOnly {
    override val snapshotCopyGrantName: Option[String] =
      scala.Option(impl.snapshotCopyGrantName()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val tagKeys: Option[List[String]] = scala
      .Option(impl.tagKeys())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val tagValues: Option[List[String]] = scala
      .Option(impl.tagValues())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeSnapshotCopyGrantsRequest
  ): zio.aws.redshift.model.DescribeSnapshotCopyGrantsRequest.ReadOnly =
    new Wrapper(impl)
}
