package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterParameterGroup(
    parameterGroupName: Option[String] = None,
    parameterGroupFamily: Option[String] = None,
    description: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterParameterGroup = {
    import ClusterParameterGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
      .builder()
      .optionallyWith(parameterGroupName.map(value => value: java.lang.String))(
        _.parameterGroupName
      )
      .optionallyWith(
        parameterGroupFamily.map(value => value: java.lang.String)
      )(_.parameterGroupFamily)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterParameterGroup.ReadOnly =
    zio.aws.redshift.model.ClusterParameterGroup.wrap(buildAwsValue())
}
object ClusterParameterGroup {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterParameterGroup =
      zio.aws.redshift.model.ClusterParameterGroup(
        parameterGroupName.map(value => value),
        parameterGroupFamily.map(value => value),
        description.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: Option[String]
    def parameterGroupFamily: Option[String]
    def description: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getParameterGroupName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupName", parameterGroupName)
    def getParameterGroupFamily: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("parameterGroupFamily", parameterGroupFamily)
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
  ) extends zio.aws.redshift.model.ClusterParameterGroup.ReadOnly {
    override val parameterGroupName: Option[String] =
      scala.Option(impl.parameterGroupName()).map(value => value: String)
    override val parameterGroupFamily: Option[String] =
      scala.Option(impl.parameterGroupFamily()).map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterParameterGroup
  ): zio.aws.redshift.model.ClusterParameterGroup.ReadOnly = new Wrapper(impl)
}
