package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeScheduledActionsResponse(
    marker: Option[String] = None,
    scheduledActions: Option[Iterable[zio.aws.redshift.model.ScheduledAction]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse = {
    import DescribeScheduledActionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        scheduledActions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scheduledActions)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeScheduledActionsResponse
      .wrap(buildAwsValue())
}
object DescribeScheduledActionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeScheduledActionsResponse =
      zio.aws.redshift.model.DescribeScheduledActionsResponse(
        marker.map(value => value),
        scheduledActions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def scheduledActions
        : Option[List[zio.aws.redshift.model.ScheduledAction.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getScheduledActions: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ScheduledAction.ReadOnly
    ]] = AwsError.unwrapOptionField("scheduledActions", scheduledActions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
  ) extends zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val scheduledActions
        : Option[List[zio.aws.redshift.model.ScheduledAction.ReadOnly]] = scala
      .Option(impl.scheduledActions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ScheduledAction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeScheduledActionsResponse
  ): zio.aws.redshift.model.DescribeScheduledActionsResponse.ReadOnly =
    new Wrapper(impl)
}
