package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{IntegerOptional, BooleanOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEndpointAuthorizationRequest(
    clusterIdentifier: Option[String] = None,
    account: Option[String] = None,
    grantee: Option[BooleanOptional] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest = {
    import DescribeEndpointAuthorizationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(account.map(value => value: java.lang.String))(_.account)
      .optionallyWith(
        grantee.map(value => BooleanOptional.unwrap(value): java.lang.Boolean)
      )(_.grantee)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEndpointAuthorizationRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEndpointAuthorizationRequest
      .wrap(buildAwsValue())
}
object DescribeEndpointAuthorizationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeEndpointAuthorizationRequest =
      zio.aws.redshift.model.DescribeEndpointAuthorizationRequest(
        clusterIdentifier.map(value => value),
        account.map(value => value),
        grantee.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def account: Option[String]
    def grantee: Option[BooleanOptional]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("account", account)
    def getGrantee: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
  ) extends zio.aws.redshift.model.DescribeEndpointAuthorizationRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val account: Option[String] =
      scala.Option(impl.account()).map(value => value: String)
    override val grantee: Option[BooleanOptional] = scala
      .Option(impl.grantee())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEndpointAuthorizationRequest
  ): zio.aws.redshift.model.DescribeEndpointAuthorizationRequest.ReadOnly =
    new Wrapper(impl)
}
