package zio.aws.redshift.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.{IntegerOptional, TStamp}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateSnapshotScheduleResponse(
    scheduleDefinitions: Option[Iterable[String]] = None,
    scheduleIdentifier: Option[String] = None,
    scheduleDescription: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None,
    nextInvocations: Option[Iterable[TStamp]] = None,
    associatedClusterCount: Option[IntegerOptional] = None,
    associatedClusters: Option[
      Iterable[zio.aws.redshift.model.ClusterAssociatedToSchedule]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse = {
    import CreateSnapshotScheduleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse
      .builder()
      .optionallyWith(
        scheduleDefinitions.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.scheduleDefinitions)
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        scheduleDescription.map(value => value: java.lang.String)
      )(_.scheduleDescription)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        nextInvocations.map(value =>
          value.map { item =>
            TStamp.unwrap(item): Instant
          }.asJavaCollection
        )
      )(_.nextInvocations)
      .optionallyWith(
        associatedClusterCount.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.associatedClusterCount)
      .optionallyWith(
        associatedClusters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associatedClusters)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly =
    zio.aws.redshift.model.CreateSnapshotScheduleResponse.wrap(buildAwsValue())
}
object CreateSnapshotScheduleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateSnapshotScheduleResponse =
      zio.aws.redshift.model.CreateSnapshotScheduleResponse(
        scheduleDefinitions.map(value => value),
        scheduleIdentifier.map(value => value),
        scheduleDescription.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextInvocations.map(value => value),
        associatedClusterCount.map(value => value),
        associatedClusters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scheduleDefinitions: Option[List[String]]
    def scheduleIdentifier: Option[String]
    def scheduleDescription: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def nextInvocations: Option[List[TStamp]]
    def associatedClusterCount: Option[IntegerOptional]
    def associatedClusters: Option[
      List[zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly]
    ]
    def getScheduleDefinitions: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("scheduleDefinitions", scheduleDefinitions)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getScheduleDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleDescription", scheduleDescription)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getNextInvocations: ZIO[Any, AwsError, List[TStamp]] =
      AwsError.unwrapOptionField("nextInvocations", nextInvocations)
    def getAssociatedClusterCount: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "associatedClusterCount",
        associatedClusterCount
      )
    def getAssociatedClusters: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly
    ]] = AwsError.unwrapOptionField("associatedClusters", associatedClusters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse
  ) extends zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly {
    override val scheduleDefinitions: Option[List[String]] = scala
      .Option(impl.scheduleDefinitions())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val scheduleIdentifier: Option[String] =
      scala.Option(impl.scheduleIdentifier()).map(value => value: String)
    override val scheduleDescription: Option[String] =
      scala.Option(impl.scheduleDescription()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
    override val nextInvocations: Option[List[TStamp]] = scala
      .Option(impl.nextInvocations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.primitives.TStamp(item)
        }.toList
      )
    override val associatedClusterCount: Option[IntegerOptional] = scala
      .Option(impl.associatedClusterCount())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val associatedClusters: Option[
      List[zio.aws.redshift.model.ClusterAssociatedToSchedule.ReadOnly]
    ] = scala
      .Option(impl.associatedClusters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ClusterAssociatedToSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotScheduleResponse
  ): zio.aws.redshift.model.CreateSnapshotScheduleResponse.ReadOnly =
    new Wrapper(impl)
}
