package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateHsmClientCertificateRequest(
    hsmClientCertificateIdentifier: String,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest = {
    import CreateHsmClientCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest
      .builder()
      .hsmClientCertificateIdentifier(
        hsmClientCertificateIdentifier: java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateHsmClientCertificateRequest.ReadOnly =
    zio.aws.redshift.model.CreateHsmClientCertificateRequest
      .wrap(buildAwsValue())
}
object CreateHsmClientCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateHsmClientCertificateRequest =
      zio.aws.redshift.model.CreateHsmClientCertificateRequest(
        hsmClientCertificateIdentifier,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hsmClientCertificateIdentifier: String
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getHsmClientCertificateIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(hsmClientCertificateIdentifier)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest
  ) extends zio.aws.redshift.model.CreateHsmClientCertificateRequest.ReadOnly {
    override val hsmClientCertificateIdentifier: String =
      impl.hsmClientCertificateIdentifier(): String
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateHsmClientCertificateRequest
  ): zio.aws.redshift.model.CreateHsmClientCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
