package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClusterSnapshotScheduleRequest(
    clusterIdentifier: String,
    scheduleIdentifier: Option[String] = None,
    disassociateSchedule: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest = {
    import ModifyClusterSnapshotScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(scheduleIdentifier.map(value => value: java.lang.String))(
        _.scheduleIdentifier
      )
      .optionallyWith(
        disassociateSchedule.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.disassociateSchedule)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest
      .wrap(buildAwsValue())
}
object ModifyClusterSnapshotScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest =
      zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest(
        clusterIdentifier,
        scheduleIdentifier.map(value => value),
        disassociateSchedule.map(value => value)
      )
    def clusterIdentifier: String
    def scheduleIdentifier: Option[String]
    def disassociateSchedule: Option[BooleanOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("scheduleIdentifier", scheduleIdentifier)
    def getDisassociateSchedule: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("disassociateSchedule", disassociateSchedule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
  ) extends zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val scheduleIdentifier: Option[String] =
      scala.Option(impl.scheduleIdentifier()).map(value => value: String)
    override val disassociateSchedule: Option[BooleanOptional] = scala
      .Option(impl.disassociateSchedule())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotScheduleRequest
  ): zio.aws.redshift.model.ModifyClusterSnapshotScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
