package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterSubnetGroupResponse(
    clusterSubnetGroup: Option[zio.aws.redshift.model.ClusterSubnetGroup] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse = {
    import CreateClusterSubnetGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse
      .builder()
      .optionallyWith(clusterSubnetGroup.map(value => value.buildAwsValue()))(
        _.clusterSubnetGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly =
    zio.aws.redshift.model.CreateClusterSubnetGroupResponse
      .wrap(buildAwsValue())
}
object CreateClusterSubnetGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterSubnetGroupResponse =
      zio.aws.redshift.model.CreateClusterSubnetGroupResponse(
        clusterSubnetGroup.map(value => value.asEditable)
      )
    def clusterSubnetGroup
        : Option[zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly]
    def getClusterSubnetGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSubnetGroup", clusterSubnetGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse
  ) extends zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly {
    override val clusterSubnetGroup
        : Option[zio.aws.redshift.model.ClusterSubnetGroup.ReadOnly] = scala
      .Option(impl.clusterSubnetGroup())
      .map(value => zio.aws.redshift.model.ClusterSubnetGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterSubnetGroupResponse
  ): zio.aws.redshift.model.CreateClusterSubnetGroupResponse.ReadOnly =
    new Wrapper(impl)
}
