package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeClusterSecurityGroupIngressResponse(
    clusterSecurityGroup: Option[zio.aws.redshift.model.ClusterSecurityGroup] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse = {
    import AuthorizeClusterSecurityGroupIngressResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
      .builder()
      .optionallyWith(clusterSecurityGroup.map(value => value.buildAwsValue()))(
        _.clusterSecurityGroup
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly =
    zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
      .wrap(buildAwsValue())
}
object AuthorizeClusterSecurityGroupIngressResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse =
      zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse(
        clusterSecurityGroup.map(value => value.asEditable)
      )
    def clusterSecurityGroup
        : Option[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly]
    def getClusterSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("clusterSecurityGroup", clusterSecurityGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
  ) extends zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly {
    override val clusterSecurityGroup
        : Option[zio.aws.redshift.model.ClusterSecurityGroup.ReadOnly] = scala
      .Option(impl.clusterSecurityGroup())
      .map(value => zio.aws.redshift.model.ClusterSecurityGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeClusterSecurityGroupIngressResponse
  ): zio.aws.redshift.model.AuthorizeClusterSecurityGroupIngressResponse.ReadOnly =
    new Wrapper(impl)
}
