package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateUsageLimitRequest(
    clusterIdentifier: String,
    featureType: zio.aws.redshift.model.UsageLimitFeatureType,
    limitType: zio.aws.redshift.model.UsageLimitLimitType,
    amount: Long,
    period: Option[zio.aws.redshift.model.UsageLimitPeriod] = None,
    breachAction: Option[zio.aws.redshift.model.UsageLimitBreachAction] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest = {
    import CreateUsageLimitRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .featureType(featureType.unwrap)
      .limitType(limitType.unwrap)
      .amount(amount: java.lang.Long)
      .optionallyWith(period.map(value => value.unwrap))(_.period)
      .optionallyWith(breachAction.map(value => value.unwrap))(_.breachAction)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateUsageLimitRequest.ReadOnly =
    zio.aws.redshift.model.CreateUsageLimitRequest.wrap(buildAwsValue())
}
object CreateUsageLimitRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateUsageLimitRequest =
      zio.aws.redshift.model.CreateUsageLimitRequest(
        clusterIdentifier,
        featureType,
        limitType,
        amount,
        period.map(value => value),
        breachAction.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clusterIdentifier: String
    def featureType: zio.aws.redshift.model.UsageLimitFeatureType
    def limitType: zio.aws.redshift.model.UsageLimitLimitType
    def amount: Long
    def period: Option[zio.aws.redshift.model.UsageLimitPeriod]
    def breachAction: Option[zio.aws.redshift.model.UsageLimitBreachAction]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getFeatureType
        : ZIO[Any, Nothing, zio.aws.redshift.model.UsageLimitFeatureType] =
      ZIO.succeed(featureType)
    def getLimitType
        : ZIO[Any, Nothing, zio.aws.redshift.model.UsageLimitLimitType] =
      ZIO.succeed(limitType)
    def getAmount: ZIO[Any, Nothing, Long] = ZIO.succeed(amount)
    def getPeriod: ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitPeriod] =
      AwsError.unwrapOptionField("period", period)
    def getBreachAction
        : ZIO[Any, AwsError, zio.aws.redshift.model.UsageLimitBreachAction] =
      AwsError.unwrapOptionField("breachAction", breachAction)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest
  ) extends zio.aws.redshift.model.CreateUsageLimitRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val featureType: zio.aws.redshift.model.UsageLimitFeatureType =
      zio.aws.redshift.model.UsageLimitFeatureType.wrap(impl.featureType())
    override val limitType: zio.aws.redshift.model.UsageLimitLimitType =
      zio.aws.redshift.model.UsageLimitLimitType.wrap(impl.limitType())
    override val amount: Long = impl.amount(): Long
    override val period: Option[zio.aws.redshift.model.UsageLimitPeriod] = scala
      .Option(impl.period())
      .map(value => zio.aws.redshift.model.UsageLimitPeriod.wrap(value))
    override val breachAction
        : Option[zio.aws.redshift.model.UsageLimitBreachAction] = scala
      .Option(impl.breachAction())
      .map(value => zio.aws.redshift.model.UsageLimitBreachAction.wrap(value))
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateUsageLimitRequest
  ): zio.aws.redshift.model.CreateUsageLimitRequest.ReadOnly = new Wrapper(impl)
}
