package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeTableRestoreStatusRequest(
    clusterIdentifier: Option[String] = None,
    tableRestoreRequestId: Option[String] = None,
    maxRecords: Option[IntegerOptional] = None,
    marker: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest = {
    import DescribeTableRestoreStatusRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        tableRestoreRequestId.map(value => value: java.lang.String)
      )(_.tableRestoreRequestId)
      .optionallyWith(
        maxRecords.map(value => IntegerOptional.unwrap(value): Integer)
      )(_.maxRecords)
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeTableRestoreStatusRequest.ReadOnly =
    zio.aws.redshift.model.DescribeTableRestoreStatusRequest
      .wrap(buildAwsValue())
}
object DescribeTableRestoreStatusRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeTableRestoreStatusRequest =
      zio.aws.redshift.model.DescribeTableRestoreStatusRequest(
        clusterIdentifier.map(value => value),
        tableRestoreRequestId.map(value => value),
        maxRecords.map(value => value),
        marker.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def tableRestoreRequestId: Option[String]
    def maxRecords: Option[IntegerOptional]
    def marker: Option[String]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getTableRestoreRequestId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("tableRestoreRequestId", tableRestoreRequestId)
    def getMaxRecords: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("maxRecords", maxRecords)
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
  ) extends zio.aws.redshift.model.DescribeTableRestoreStatusRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val tableRestoreRequestId: Option[String] =
      scala.Option(impl.tableRestoreRequestId()).map(value => value: String)
    override val maxRecords: Option[IntegerOptional] = scala
      .Option(impl.maxRecords())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeTableRestoreStatusRequest
  ): zio.aws.redshift.model.DescribeTableRestoreStatusRequest.ReadOnly =
    new Wrapper(impl)
}
