package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{IntegerOptional, Integer, TStamp}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Snapshot(
    snapshotIdentifier: Option[String] = None,
    clusterIdentifier: Option[String] = None,
    snapshotCreateTime: Option[TStamp] = None,
    status: Option[String] = None,
    port: Option[Integer] = None,
    availabilityZone: Option[String] = None,
    clusterCreateTime: Option[TStamp] = None,
    masterUsername: Option[String] = None,
    clusterVersion: Option[String] = None,
    engineFullVersion: Option[String] = None,
    snapshotType: Option[String] = None,
    nodeType: Option[String] = None,
    numberOfNodes: Option[Integer] = None,
    dbName: Option[String] = None,
    vpcId: Option[String] = None,
    encrypted: Option[Boolean] = None,
    kmsKeyId: Option[String] = None,
    encryptedWithHSM: Option[Boolean] = None,
    accountsWithRestoreAccess: Option[
      Iterable[zio.aws.redshift.model.AccountWithRestoreAccess]
    ] = None,
    ownerAccount: Option[String] = None,
    totalBackupSizeInMegaBytes: Option[Double] = None,
    actualIncrementalBackupSizeInMegaBytes: Option[Double] = None,
    backupProgressInMegaBytes: Option[Double] = None,
    currentBackupRateInMegaBytesPerSecond: Option[Double] = None,
    estimatedSecondsToCompletion: Option[Long] = None,
    elapsedTimeInSeconds: Option[Long] = None,
    sourceRegion: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None,
    restorableNodeTypes: Option[Iterable[String]] = None,
    enhancedVpcRouting: Option[Boolean] = None,
    maintenanceTrackName: Option[String] = None,
    manualSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    manualSnapshotRemainingDays: Option[IntegerOptional] = None,
    snapshotRetentionStartTime: Option[TStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.Snapshot = {
    import Snapshot.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Snapshot
      .builder()
      .optionallyWith(snapshotIdentifier.map(value => value: java.lang.String))(
        _.snapshotIdentifier
      )
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .optionallyWith(
        snapshotCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotCreateTime)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .optionallyWith(
        port.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.port)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        clusterCreateTime.map(value => TStamp.unwrap(value): Instant)
      )(_.clusterCreateTime)
      .optionallyWith(masterUsername.map(value => value: java.lang.String))(
        _.masterUsername
      )
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(engineFullVersion.map(value => value: java.lang.String))(
        _.engineFullVersion
      )
      .optionallyWith(snapshotType.map(value => value: java.lang.String))(
        _.snapshotType
      )
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(
        numberOfNodes.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.numberOfNodes)
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .optionallyWith(vpcId.map(value => value: java.lang.String))(_.vpcId)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(encryptedWithHSM.map(value => value: java.lang.Boolean))(
        _.encryptedWithHSM
      )
      .optionallyWith(
        accountsWithRestoreAccess.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accountsWithRestoreAccess)
      .optionallyWith(ownerAccount.map(value => value: java.lang.String))(
        _.ownerAccount
      )
      .optionallyWith(
        totalBackupSizeInMegaBytes.map(value => value: java.lang.Double)
      )(_.totalBackupSizeInMegaBytes)
      .optionallyWith(
        actualIncrementalBackupSizeInMegaBytes.map(value =>
          value: java.lang.Double
        )
      )(_.actualIncrementalBackupSizeInMegaBytes)
      .optionallyWith(
        backupProgressInMegaBytes.map(value => value: java.lang.Double)
      )(_.backupProgressInMegaBytes)
      .optionallyWith(
        currentBackupRateInMegaBytesPerSecond.map(value =>
          value: java.lang.Double
        )
      )(_.currentBackupRateInMegaBytesPerSecond)
      .optionallyWith(
        estimatedSecondsToCompletion.map(value => value: java.lang.Long)
      )(_.estimatedSecondsToCompletion)
      .optionallyWith(elapsedTimeInSeconds.map(value => value: java.lang.Long))(
        _.elapsedTimeInSeconds
      )
      .optionallyWith(sourceRegion.map(value => value: java.lang.String))(
        _.sourceRegion
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        restorableNodeTypes.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.restorableNodeTypes)
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): java.lang.Integer
        )
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRemainingDays.map(value =>
          IntegerOptional.unwrap(value): java.lang.Integer
        )
      )(_.manualSnapshotRemainingDays)
      .optionallyWith(
        snapshotRetentionStartTime.map(value => TStamp.unwrap(value): Instant)
      )(_.snapshotRetentionStartTime)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Snapshot.ReadOnly =
    zio.aws.redshift.model.Snapshot.wrap(buildAwsValue())
}
object Snapshot {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Snapshot] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Snapshot =
      zio.aws.redshift.model.Snapshot(
        snapshotIdentifier.map(value => value),
        clusterIdentifier.map(value => value),
        snapshotCreateTime.map(value => value),
        status.map(value => value),
        port.map(value => value),
        availabilityZone.map(value => value),
        clusterCreateTime.map(value => value),
        masterUsername.map(value => value),
        clusterVersion.map(value => value),
        engineFullVersion.map(value => value),
        snapshotType.map(value => value),
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        dbName.map(value => value),
        vpcId.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value),
        encryptedWithHSM.map(value => value),
        accountsWithRestoreAccess.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        ownerAccount.map(value => value),
        totalBackupSizeInMegaBytes.map(value => value),
        actualIncrementalBackupSizeInMegaBytes.map(value => value),
        backupProgressInMegaBytes.map(value => value),
        currentBackupRateInMegaBytesPerSecond.map(value => value),
        estimatedSecondsToCompletion.map(value => value),
        elapsedTimeInSeconds.map(value => value),
        sourceRegion.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        restorableNodeTypes.map(value => value),
        enhancedVpcRouting.map(value => value),
        maintenanceTrackName.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRemainingDays.map(value => value),
        snapshotRetentionStartTime.map(value => value)
      )
    def snapshotIdentifier: Option[String]
    def clusterIdentifier: Option[String]
    def snapshotCreateTime: Option[TStamp]
    def status: Option[String]
    def port: Option[Integer]
    def availabilityZone: Option[String]
    def clusterCreateTime: Option[TStamp]
    def masterUsername: Option[String]
    def clusterVersion: Option[String]
    def engineFullVersion: Option[String]
    def snapshotType: Option[String]
    def nodeType: Option[String]
    def numberOfNodes: Option[Integer]
    def dbName: Option[String]
    def vpcId: Option[String]
    def encrypted: Option[Boolean]
    def kmsKeyId: Option[String]
    def encryptedWithHSM: Option[Boolean]
    def accountsWithRestoreAccess
        : Option[List[zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly]]
    def ownerAccount: Option[String]
    def totalBackupSizeInMegaBytes: Option[Double]
    def actualIncrementalBackupSizeInMegaBytes: Option[Double]
    def backupProgressInMegaBytes: Option[Double]
    def currentBackupRateInMegaBytesPerSecond: Option[Double]
    def estimatedSecondsToCompletion: Option[Long]
    def elapsedTimeInSeconds: Option[Long]
    def sourceRegion: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def restorableNodeTypes: Option[List[String]]
    def enhancedVpcRouting: Option[Boolean]
    def maintenanceTrackName: Option[String]
    def manualSnapshotRetentionPeriod: Option[IntegerOptional]
    def manualSnapshotRemainingDays: Option[IntegerOptional]
    def snapshotRetentionStartTime: Option[TStamp]
    def getSnapshotIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotIdentifier", snapshotIdentifier)
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getSnapshotCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("snapshotCreateTime", snapshotCreateTime)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
    def getPort: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("port", port)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getClusterCreateTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("clusterCreateTime", clusterCreateTime)
    def getMasterUsername: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("masterUsername", masterUsername)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getEngineFullVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("engineFullVersion", engineFullVersion)
    def getSnapshotType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("snapshotType", snapshotType)
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getVpcId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getEncrypted: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEncryptedWithHSM: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("encryptedWithHSM", encryptedWithHSM)
    def getAccountsWithRestoreAccess: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "accountsWithRestoreAccess",
      accountsWithRestoreAccess
    )
    def getOwnerAccount: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getTotalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "totalBackupSizeInMegaBytes",
        totalBackupSizeInMegaBytes
      )
    def getActualIncrementalBackupSizeInMegaBytes: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "actualIncrementalBackupSizeInMegaBytes",
        actualIncrementalBackupSizeInMegaBytes
      )
    def getBackupProgressInMegaBytes: ZIO[Any, AwsError, Double] = AwsError
      .unwrapOptionField("backupProgressInMegaBytes", backupProgressInMegaBytes)
    def getCurrentBackupRateInMegaBytesPerSecond: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField(
        "currentBackupRateInMegaBytesPerSecond",
        currentBackupRateInMegaBytesPerSecond
      )
    def getEstimatedSecondsToCompletion: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField(
        "estimatedSecondsToCompletion",
        estimatedSecondsToCompletion
      )
    def getElapsedTimeInSeconds: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("elapsedTimeInSeconds", elapsedTimeInSeconds)
    def getSourceRegion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceRegion", sourceRegion)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getRestorableNodeTypes: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("restorableNodeTypes", restorableNodeTypes)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getManualSnapshotRemainingDays: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRemainingDays",
        manualSnapshotRemainingDays
      )
    def getSnapshotRetentionStartTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "snapshotRetentionStartTime",
        snapshotRetentionStartTime
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Snapshot
  ) extends zio.aws.redshift.model.Snapshot.ReadOnly {
    override val snapshotIdentifier: Option[String] =
      scala.Option(impl.snapshotIdentifier()).map(value => value: String)
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val snapshotCreateTime: Option[TStamp] = scala
      .Option(impl.snapshotCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
    override val port: Option[Integer] = scala
      .Option(impl.port())
      .map(value => zio.aws.redshift.model.primitives.Integer(value))
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val clusterCreateTime: Option[TStamp] = scala
      .Option(impl.clusterCreateTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val masterUsername: Option[String] =
      scala.Option(impl.masterUsername()).map(value => value: String)
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val engineFullVersion: Option[String] =
      scala.Option(impl.engineFullVersion()).map(value => value: String)
    override val snapshotType: Option[String] =
      scala.Option(impl.snapshotType()).map(value => value: String)
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val numberOfNodes: Option[Integer] = scala
      .Option(impl.numberOfNodes())
      .map(value => zio.aws.redshift.model.primitives.Integer(value))
    override val dbName: Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val vpcId: Option[String] =
      scala.Option(impl.vpcId()).map(value => value: String)
    override val encrypted: Option[Boolean] =
      scala.Option(impl.encrypted()).map(value => value: Boolean)
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val encryptedWithHSM: Option[Boolean] =
      scala.Option(impl.encryptedWithHSM()).map(value => value: Boolean)
    override val accountsWithRestoreAccess: Option[
      List[zio.aws.redshift.model.AccountWithRestoreAccess.ReadOnly]
    ] = scala
      .Option(impl.accountsWithRestoreAccess())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.AccountWithRestoreAccess.wrap(item)
        }.toList
      )
    override val ownerAccount: Option[String] =
      scala.Option(impl.ownerAccount()).map(value => value: String)
    override val totalBackupSizeInMegaBytes: Option[Double] = scala
      .Option(impl.totalBackupSizeInMegaBytes())
      .map(value => value: Double)
    override val actualIncrementalBackupSizeInMegaBytes: Option[Double] = scala
      .Option(impl.actualIncrementalBackupSizeInMegaBytes())
      .map(value => value: Double)
    override val backupProgressInMegaBytes: Option[Double] =
      scala.Option(impl.backupProgressInMegaBytes()).map(value => value: Double)
    override val currentBackupRateInMegaBytesPerSecond: Option[Double] = scala
      .Option(impl.currentBackupRateInMegaBytesPerSecond())
      .map(value => value: Double)
    override val estimatedSecondsToCompletion: Option[Long] = scala
      .Option(impl.estimatedSecondsToCompletion())
      .map(value => value: Long)
    override val elapsedTimeInSeconds: Option[Long] =
      scala.Option(impl.elapsedTimeInSeconds()).map(value => value: Long)
    override val sourceRegion: Option[String] =
      scala.Option(impl.sourceRegion()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
    override val restorableNodeTypes: Option[List[String]] = scala
      .Option(impl.restorableNodeTypes())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val enhancedVpcRouting: Option[Boolean] =
      scala.Option(impl.enhancedVpcRouting()).map(value => value: Boolean)
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val manualSnapshotRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val manualSnapshotRemainingDays: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRemainingDays())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val snapshotRetentionStartTime: Option[TStamp] = scala
      .Option(impl.snapshotRetentionStartTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Snapshot
  ): zio.aws.redshift.model.Snapshot.ReadOnly = new Wrapper(impl)
}
