package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.BooleanOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RestoreTableFromClusterSnapshotRequest(
    clusterIdentifier: String,
    snapshotIdentifier: String,
    sourceDatabaseName: String,
    sourceSchemaName: Option[String] = None,
    sourceTableName: String,
    targetDatabaseName: Option[String] = None,
    targetSchemaName: Option[String] = None,
    newTableName: String,
    enableCaseSensitiveIdentifier: Option[BooleanOptional] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest = {
    import RestoreTableFromClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .sourceDatabaseName(sourceDatabaseName: java.lang.String)
      .optionallyWith(sourceSchemaName.map(value => value: java.lang.String))(
        _.sourceSchemaName
      )
      .sourceTableName(sourceTableName: java.lang.String)
      .optionallyWith(targetDatabaseName.map(value => value: java.lang.String))(
        _.targetDatabaseName
      )
      .optionallyWith(targetSchemaName.map(value => value: java.lang.String))(
        _.targetSchemaName
      )
      .newTableName(newTableName: java.lang.String)
      .optionallyWith(
        enableCaseSensitiveIdentifier.map(value =>
          BooleanOptional.unwrap(value): java.lang.Boolean
        )
      )(_.enableCaseSensitiveIdentifier)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.RestoreTableFromClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.RestoreTableFromClusterSnapshotRequest
      .wrap(buildAwsValue())
}
object RestoreTableFromClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.RestoreTableFromClusterSnapshotRequest =
      zio.aws.redshift.model.RestoreTableFromClusterSnapshotRequest(
        clusterIdentifier,
        snapshotIdentifier,
        sourceDatabaseName,
        sourceSchemaName.map(value => value),
        sourceTableName,
        targetDatabaseName.map(value => value),
        targetSchemaName.map(value => value),
        newTableName,
        enableCaseSensitiveIdentifier.map(value => value)
      )
    def clusterIdentifier: String
    def snapshotIdentifier: String
    def sourceDatabaseName: String
    def sourceSchemaName: Option[String]
    def sourceTableName: String
    def targetDatabaseName: Option[String]
    def targetSchemaName: Option[String]
    def newTableName: String
    def enableCaseSensitiveIdentifier: Option[BooleanOptional]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSourceDatabaseName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceDatabaseName)
    def getSourceSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceSchemaName", sourceSchemaName)
    def getSourceTableName: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceTableName)
    def getTargetDatabaseName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetDatabaseName", targetDatabaseName)
    def getTargetSchemaName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("targetSchemaName", targetSchemaName)
    def getNewTableName: ZIO[Any, Nothing, String] = ZIO.succeed(newTableName)
    def getEnableCaseSensitiveIdentifier: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "enableCaseSensitiveIdentifier",
        enableCaseSensitiveIdentifier
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest
  ) extends zio.aws.redshift.model.RestoreTableFromClusterSnapshotRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val sourceDatabaseName: String = impl.sourceDatabaseName(): String
    override val sourceSchemaName: Option[String] =
      scala.Option(impl.sourceSchemaName()).map(value => value: String)
    override val sourceTableName: String = impl.sourceTableName(): String
    override val targetDatabaseName: Option[String] =
      scala.Option(impl.targetDatabaseName()).map(value => value: String)
    override val targetSchemaName: Option[String] =
      scala.Option(impl.targetSchemaName()).map(value => value: String)
    override val newTableName: String = impl.newTableName(): String
    override val enableCaseSensitiveIdentifier: Option[BooleanOptional] = scala
      .Option(impl.enableCaseSensitiveIdentifier())
      .map(value => zio.aws.redshift.model.primitives.BooleanOptional(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.RestoreTableFromClusterSnapshotRequest
  ): zio.aws.redshift.model.RestoreTableFromClusterSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
