package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.{DoubleOptional, Integer}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeConfigurationOption(
    nodeType: Option[String] = None,
    numberOfNodes: Option[Integer] = None,
    estimatedDiskUtilizationPercent: Option[DoubleOptional] = None,
    mode: Option[zio.aws.redshift.model.Mode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.NodeConfigurationOption = {
    import NodeConfigurationOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
      .builder()
      .optionallyWith(nodeType.map(value => value: java.lang.String))(
        _.nodeType
      )
      .optionallyWith(
        numberOfNodes.map(value => Integer.unwrap(value): java.lang.Integer)
      )(_.numberOfNodes)
      .optionallyWith(
        estimatedDiskUtilizationPercent.map(value =>
          DoubleOptional.unwrap(value): java.lang.Double
        )
      )(_.estimatedDiskUtilizationPercent)
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.NodeConfigurationOption.ReadOnly =
    zio.aws.redshift.model.NodeConfigurationOption.wrap(buildAwsValue())
}
object NodeConfigurationOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.NodeConfigurationOption =
      zio.aws.redshift.model.NodeConfigurationOption(
        nodeType.map(value => value),
        numberOfNodes.map(value => value),
        estimatedDiskUtilizationPercent.map(value => value),
        mode.map(value => value)
      )
    def nodeType: Option[String]
    def numberOfNodes: Option[Integer]
    def estimatedDiskUtilizationPercent: Option[DoubleOptional]
    def mode: Option[zio.aws.redshift.model.Mode]
    def getNodeType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nodeType", nodeType)
    def getNumberOfNodes: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getEstimatedDiskUtilizationPercent: ZIO[Any, AwsError, DoubleOptional] =
      AwsError.unwrapOptionField(
        "estimatedDiskUtilizationPercent",
        estimatedDiskUtilizationPercent
      )
    def getMode: ZIO[Any, AwsError, zio.aws.redshift.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
  ) extends zio.aws.redshift.model.NodeConfigurationOption.ReadOnly {
    override val nodeType: Option[String] =
      scala.Option(impl.nodeType()).map(value => value: String)
    override val numberOfNodes: Option[Integer] = scala
      .Option(impl.numberOfNodes())
      .map(value => zio.aws.redshift.model.primitives.Integer(value))
    override val estimatedDiskUtilizationPercent: Option[DoubleOptional] = scala
      .Option(impl.estimatedDiskUtilizationPercent())
      .map(value => zio.aws.redshift.model.primitives.DoubleOptional(value))
    override val mode: Option[zio.aws.redshift.model.Mode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.redshift.model.Mode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.NodeConfigurationOption
  ): zio.aws.redshift.model.NodeConfigurationOption.ReadOnly = new Wrapper(impl)
}
