package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.IntegerOptional
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ModifyClusterSnapshotRequest(
    snapshotIdentifier: String,
    manualSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest = {
    import ModifyClusterSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value =>
          IntegerOptional.unwrap(value): Integer
        )
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ModifyClusterSnapshotRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterSnapshotRequest.wrap(buildAwsValue())
}
object ModifyClusterSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterSnapshotRequest =
      zio.aws.redshift.model.ModifyClusterSnapshotRequest(
        snapshotIdentifier,
        manualSnapshotRetentionPeriod.map(value => value),
        force.map(value => value)
      )
    def snapshotIdentifier: String
    def manualSnapshotRetentionPeriod: Option[IntegerOptional]
    def force: Option[Boolean]
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
  ) extends zio.aws.redshift.model.ModifyClusterSnapshotRequest.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val manualSnapshotRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => zio.aws.redshift.model.primitives.IntegerOptional(value))
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterSnapshotRequest
  ): zio.aws.redshift.model.ModifyClusterSnapshotRequest.ReadOnly = new Wrapper(
    impl
  )
}
