package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HsmConfiguration(
    hsmConfigurationIdentifier: Option[String] = None,
    description: Option[String] = None,
    hsmIpAddress: Option[String] = None,
    hsmPartitionName: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.HsmConfiguration = {
    import HsmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.HsmConfiguration
      .builder()
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(hsmIpAddress.map(value => value: java.lang.String))(
        _.hsmIpAddress
      )
      .optionallyWith(hsmPartitionName.map(value => value: java.lang.String))(
        _.hsmPartitionName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.HsmConfiguration.ReadOnly =
    zio.aws.redshift.model.HsmConfiguration.wrap(buildAwsValue())
}
object HsmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.HsmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.HsmConfiguration =
      zio.aws.redshift.model.HsmConfiguration(
        hsmConfigurationIdentifier.map(value => value),
        description.map(value => value),
        hsmIpAddress.map(value => value),
        hsmPartitionName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hsmConfigurationIdentifier: Option[String]
    def description: Option[String]
    def hsmIpAddress: Option[String]
    def hsmPartitionName: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getHsmIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsmIpAddress", hsmIpAddress)
    def getHsmPartitionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsmPartitionName", hsmPartitionName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.HsmConfiguration
  ) extends zio.aws.redshift.model.HsmConfiguration.ReadOnly {
    override val hsmConfigurationIdentifier: Option[String] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => value: String)
    override val description: Option[String] =
      scala.Option(impl.description()).map(value => value: String)
    override val hsmIpAddress: Option[String] =
      scala.Option(impl.hsmIpAddress()).map(value => value: String)
    override val hsmPartitionName: Option[String] =
      scala.Option(impl.hsmPartitionName()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.HsmConfiguration
  ): zio.aws.redshift.model.HsmConfiguration.ReadOnly = new Wrapper(impl)
}
