package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterParameterGroupResponse(
    clusterParameterGroup: Option[
      zio.aws.redshift.model.ClusterParameterGroup
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse = {
    import CreateClusterParameterGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse
      .builder()
      .optionallyWith(
        clusterParameterGroup.map(value => value.buildAwsValue())
      )(_.clusterParameterGroup)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly =
    zio.aws.redshift.model.CreateClusterParameterGroupResponse
      .wrap(buildAwsValue())
}
object CreateClusterParameterGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterParameterGroupResponse =
      zio.aws.redshift.model.CreateClusterParameterGroupResponse(
        clusterParameterGroup.map(value => value.asEditable)
      )
    def clusterParameterGroup
        : Option[zio.aws.redshift.model.ClusterParameterGroup.ReadOnly]
    def getClusterParameterGroup: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.ClusterParameterGroup.ReadOnly
    ] =
      AwsError.unwrapOptionField("clusterParameterGroup", clusterParameterGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse
  ) extends zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly {
    override val clusterParameterGroup
        : Option[zio.aws.redshift.model.ClusterParameterGroup.ReadOnly] = scala
      .Option(impl.clusterParameterGroup())
      .map(value => zio.aws.redshift.model.ClusterParameterGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupResponse
  ): zio.aws.redshift.model.CreateClusterParameterGroupResponse.ReadOnly =
    new Wrapper(impl)
}
