package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterSecurityGroupMembership(
    clusterSecurityGroupName: Option[String] = None,
    status: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership = {
    import ClusterSecurityGroupMembership.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership
      .builder()
      .optionallyWith(
        clusterSecurityGroupName.map(value => value: java.lang.String)
      )(_.clusterSecurityGroupName)
      .optionallyWith(status.map(value => value: java.lang.String))(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly =
    zio.aws.redshift.model.ClusterSecurityGroupMembership.wrap(buildAwsValue())
}
object ClusterSecurityGroupMembership {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterSecurityGroupMembership =
      zio.aws.redshift.model.ClusterSecurityGroupMembership(
        clusterSecurityGroupName.map(value => value),
        status.map(value => value)
      )
    def clusterSecurityGroupName: Option[String]
    def status: Option[String]
    def getClusterSecurityGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSecurityGroupName", clusterSecurityGroupName)
    def getStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership
  ) extends zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly {
    override val clusterSecurityGroupName: Option[String] =
      scala.Option(impl.clusterSecurityGroupName()).map(value => value: String)
    override val status: Option[String] =
      scala.Option(impl.status()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership
  ): zio.aws.redshift.model.ClusterSecurityGroupMembership.ReadOnly =
    new Wrapper(impl)
}
