package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeSnapshotAccessRequest(
    snapshotIdentifier: String,
    snapshotClusterIdentifier: Option[String] = None,
    accountWithRestoreAccess: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest = {
    import AuthorizeSnapshotAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest
      .builder()
      .snapshotIdentifier(snapshotIdentifier: java.lang.String)
      .optionallyWith(
        snapshotClusterIdentifier.map(value => value: java.lang.String)
      )(_.snapshotClusterIdentifier)
      .accountWithRestoreAccess(accountWithRestoreAccess: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeSnapshotAccessRequest.ReadOnly =
    zio.aws.redshift.model.AuthorizeSnapshotAccessRequest.wrap(buildAwsValue())
}
object AuthorizeSnapshotAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthorizeSnapshotAccessRequest =
      zio.aws.redshift.model.AuthorizeSnapshotAccessRequest(
        snapshotIdentifier,
        snapshotClusterIdentifier.map(value => value),
        accountWithRestoreAccess
      )
    def snapshotIdentifier: String
    def snapshotClusterIdentifier: Option[String]
    def accountWithRestoreAccess: String
    def getSnapshotIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotIdentifier)
    def getSnapshotClusterIdentifier: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("snapshotClusterIdentifier", snapshotClusterIdentifier)
    def getAccountWithRestoreAccess: ZIO[Any, Nothing, String] =
      ZIO.succeed(accountWithRestoreAccess)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest
  ) extends zio.aws.redshift.model.AuthorizeSnapshotAccessRequest.ReadOnly {
    override val snapshotIdentifier: String = impl.snapshotIdentifier(): String
    override val snapshotClusterIdentifier: Option[String] =
      scala.Option(impl.snapshotClusterIdentifier()).map(value => value: String)
    override val accountWithRestoreAccess: String =
      impl.accountWithRestoreAccess(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeSnapshotAccessRequest
  ): zio.aws.redshift.model.AuthorizeSnapshotAccessRequest.ReadOnly =
    new Wrapper(impl)
}
