package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthorizeEndpointAccessRequest(
    clusterIdentifier: Option[String] = None,
    account: String,
    vpcIds: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest = {
    import AuthorizeEndpointAccessRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest
      .builder()
      .optionallyWith(clusterIdentifier.map(value => value: java.lang.String))(
        _.clusterIdentifier
      )
      .account(account: java.lang.String)
      .optionallyWith(
        vpcIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcIds)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.AuthorizeEndpointAccessRequest.ReadOnly =
    zio.aws.redshift.model.AuthorizeEndpointAccessRequest.wrap(buildAwsValue())
}
object AuthorizeEndpointAccessRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthorizeEndpointAccessRequest =
      zio.aws.redshift.model.AuthorizeEndpointAccessRequest(
        clusterIdentifier.map(value => value),
        account,
        vpcIds.map(value => value)
      )
    def clusterIdentifier: Option[String]
    def account: String
    def vpcIds: Option[List[String]]
    def getClusterIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterIdentifier", clusterIdentifier)
    def getAccount: ZIO[Any, Nothing, String] = ZIO.succeed(account)
    def getVpcIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcIds", vpcIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest
  ) extends zio.aws.redshift.model.AuthorizeEndpointAccessRequest.ReadOnly {
    override val clusterIdentifier: Option[String] =
      scala.Option(impl.clusterIdentifier()).map(value => value: String)
    override val account: String = impl.account(): String
    override val vpcIds: Option[List[String]] = scala
      .Option(impl.vpcIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthorizeEndpointAccessRequest
  ): zio.aws.redshift.model.AuthorizeEndpointAccessRequest.ReadOnly =
    new Wrapper(impl)
}
