package zio.aws.redshift.model
import scala.jdk.CollectionConverters._
sealed trait UsageLimitFeatureType {
  def unwrap
      : software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType
}
object UsageLimitFeatureType {
  def wrap(
      value: software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType
  ): zio.aws.redshift.model.UsageLimitFeatureType = value match {
    case software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType.SPECTRUM =>
      val r = spectrum
      r
    case software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType.CONCURRENCY_SCALING =>
      val r = `concurrency-scaling`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.redshift.model.UsageLimitFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType =
      software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType.UNKNOWN_TO_SDK_VERSION
  }
  case object spectrum extends zio.aws.redshift.model.UsageLimitFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType =
      software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType.SPECTRUM
  }
  case object `concurrency-scaling`
      extends zio.aws.redshift.model.UsageLimitFeatureType {
    override def unwrap
        : software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType =
      software.amazon.awssdk.services.redshift.model.UsageLimitFeatureType.CONCURRENCY_SCALING
  }
}
