package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedNodeOfferingsResponse(
    marker: Option[String] = None,
    reservedNodeOfferings: Option[
      Iterable[zio.aws.redshift.model.ReservedNodeOffering]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse = {
    import DescribeReservedNodeOfferingsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedNodeOfferings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedNodeOfferings)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse
      .wrap(buildAwsValue())
}
object DescribeReservedNodeOfferingsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse =
      zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse(
        marker.map(value => value),
        reservedNodeOfferings.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def reservedNodeOfferings
        : Option[List[zio.aws.redshift.model.ReservedNodeOffering.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedNodeOfferings: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ReservedNodeOffering.ReadOnly
    ]] =
      AwsError.unwrapOptionField("reservedNodeOfferings", reservedNodeOfferings)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse
  ) extends zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedNodeOfferings
        : Option[List[zio.aws.redshift.model.ReservedNodeOffering.ReadOnly]] =
      scala
        .Option(impl.reservedNodeOfferings())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.ReservedNodeOffering.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodeOfferingsResponse
  ): zio.aws.redshift.model.DescribeReservedNodeOfferingsResponse.ReadOnly =
    new Wrapper(impl)
}
