package zio.aws.redshift.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.IntegerOptional
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetClusterCredentialsWithIamRequest(
    dbName: Optional[String] = Optional.Absent,
    clusterIdentifier: String,
    durationSeconds: Optional[IntegerOptional] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest = {
    import GetClusterCredentialsWithIamRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
      .builder()
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(durationSeconds.map(value => value: Integer))(
        _.durationSeconds
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.GetClusterCredentialsWithIamRequest.ReadOnly =
    zio.aws.redshift.model.GetClusterCredentialsWithIamRequest
      .wrap(buildAwsValue())
}
object GetClusterCredentialsWithIamRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.GetClusterCredentialsWithIamRequest =
      zio.aws.redshift.model.GetClusterCredentialsWithIamRequest(
        dbName.map(value => value),
        clusterIdentifier,
        durationSeconds.map(value => value)
      )
    def dbName: Optional[String]
    def clusterIdentifier: String
    def durationSeconds: Optional[IntegerOptional]
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getDurationSeconds: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("durationSeconds", durationSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
  ) extends zio.aws.redshift.model.GetClusterCredentialsWithIamRequest.ReadOnly {
    override val dbName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.dbName())
      .map(value => value: String)
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val durationSeconds: Optional[IntegerOptional] =
      zio.aws.core.internal
        .optionalFromNullable(impl.durationSeconds())
        .map(value => value: IntegerOptional)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.GetClusterCredentialsWithIamRequest
  ): zio.aws.redshift.model.GetClusterCredentialsWithIamRequest.ReadOnly =
    new Wrapper(impl)
}
