package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteClusterResponse(
    cluster: Optional[zio.aws.redshift.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DeleteClusterResponse = {
    import DeleteClusterResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DeleteClusterResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DeleteClusterResponse.ReadOnly =
    zio.aws.redshift.model.DeleteClusterResponse.wrap(buildAwsValue())
}
object DeleteClusterResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DeleteClusterResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DeleteClusterResponse =
      zio.aws.redshift.model
        .DeleteClusterResponse(cluster.map(value => value.asEditable))
    def cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterResponse
  ) extends zio.aws.redshift.model.DeleteClusterResponse.ReadOnly {
    override val cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DeleteClusterResponse
  ): zio.aws.redshift.model.DeleteClusterResponse.ReadOnly = new Wrapper(impl)
}
