package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HsmConfiguration(
    hsmConfigurationIdentifier: Optional[String] = Optional.Absent,
    description: Optional[String] = Optional.Absent,
    hsmIpAddress: Optional[String] = Optional.Absent,
    hsmPartitionName: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.HsmConfiguration = {
    import HsmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.HsmConfiguration
      .builder()
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(description.map(value => value: java.lang.String))(
        _.description
      )
      .optionallyWith(hsmIpAddress.map(value => value: java.lang.String))(
        _.hsmIpAddress
      )
      .optionallyWith(hsmPartitionName.map(value => value: java.lang.String))(
        _.hsmPartitionName
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.HsmConfiguration.ReadOnly =
    zio.aws.redshift.model.HsmConfiguration.wrap(buildAwsValue())
}
object HsmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.HsmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.HsmConfiguration =
      zio.aws.redshift.model.HsmConfiguration(
        hsmConfigurationIdentifier.map(value => value),
        description.map(value => value),
        hsmIpAddress.map(value => value),
        hsmPartitionName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hsmConfigurationIdentifier: Optional[String]
    def description: Optional[String]
    def hsmIpAddress: Optional[String]
    def hsmPartitionName: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("description", description)
    def getHsmIpAddress: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsmIpAddress", hsmIpAddress)
    def getHsmPartitionName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("hsmPartitionName", hsmPartitionName)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.HsmConfiguration
  ) extends zio.aws.redshift.model.HsmConfiguration.ReadOnly {
    override val hsmConfigurationIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmConfigurationIdentifier())
        .map(value => value: String)
    override val description: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => value: String)
    override val hsmIpAddress: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmIpAddress())
      .map(value => value: String)
    override val hsmPartitionName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.hsmPartitionName())
      .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.HsmConfiguration
  ): zio.aws.redshift.model.HsmConfiguration.ReadOnly = new Wrapper(impl)
}
