package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class HsmClientCertificate(
    hsmClientCertificateIdentifier: Optional[String] = Optional.Absent,
    hsmClientCertificatePublicKey: Optional[String] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.redshift.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.HsmClientCertificate = {
    import HsmClientCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.HsmClientCertificate
      .builder()
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmClientCertificatePublicKey.map(value => value: java.lang.String)
      )(_.hsmClientCertificatePublicKey)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.HsmClientCertificate.ReadOnly =
    zio.aws.redshift.model.HsmClientCertificate.wrap(buildAwsValue())
}
object HsmClientCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.HsmClientCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.HsmClientCertificate =
      zio.aws.redshift.model.HsmClientCertificate(
        hsmClientCertificateIdentifier.map(value => value),
        hsmClientCertificatePublicKey.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def hsmClientCertificateIdentifier: Optional[String]
    def hsmClientCertificatePublicKey: Optional[String]
    def tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmClientCertificatePublicKey: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificatePublicKey",
        hsmClientCertificatePublicKey
      )
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.HsmClientCertificate
  ) extends zio.aws.redshift.model.HsmClientCertificate.ReadOnly {
    override val hsmClientCertificateIdentifier: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificateIdentifier())
        .map(value => value: String)
    override val hsmClientCertificatePublicKey: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hsmClientCertificatePublicKey())
        .map(value => value: String)
    override val tags: Optional[List[zio.aws.redshift.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.HsmClientCertificate
  ): zio.aws.redshift.model.HsmClientCertificate.ReadOnly = new Wrapper(impl)
}
