package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePartnersResponse(
    partnerIntegrationInfoList: Optional[
      Iterable[zio.aws.redshift.model.PartnerIntegrationInfo]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribePartnersResponse = {
    import DescribePartnersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribePartnersResponse
      .builder()
      .optionallyWith(
        partnerIntegrationInfoList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.partnerIntegrationInfoList)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribePartnersResponse.ReadOnly =
    zio.aws.redshift.model.DescribePartnersResponse.wrap(buildAwsValue())
}
object DescribePartnersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribePartnersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribePartnersResponse =
      zio.aws.redshift.model.DescribePartnersResponse(
        partnerIntegrationInfoList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def partnerIntegrationInfoList
        : Optional[List[zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly]]
    def getPartnerIntegrationInfoList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "partnerIntegrationInfoList",
      partnerIntegrationInfoList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribePartnersResponse
  ) extends zio.aws.redshift.model.DescribePartnersResponse.ReadOnly {
    override val partnerIntegrationInfoList: Optional[
      List[zio.aws.redshift.model.PartnerIntegrationInfo.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.partnerIntegrationInfoList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.PartnerIntegrationInfo.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribePartnersResponse
  ): zio.aws.redshift.model.DescribePartnersResponse.ReadOnly = new Wrapper(
    impl
  )
}
