package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyClusterMaintenanceResponse(
    cluster: Optional[zio.aws.redshift.model.Cluster] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse = {
    import ModifyClusterMaintenanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
      .builder()
      .optionallyWith(cluster.map(value => value.buildAwsValue()))(_.cluster)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly =
    zio.aws.redshift.model.ModifyClusterMaintenanceResponse
      .wrap(buildAwsValue())
}
object ModifyClusterMaintenanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterMaintenanceResponse =
      zio.aws.redshift.model.ModifyClusterMaintenanceResponse(
        cluster.map(value => value.asEditable)
      )
    def cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly]
    def getCluster
        : ZIO[Any, AwsError, zio.aws.redshift.model.Cluster.ReadOnly] =
      AwsError.unwrapOptionField("cluster", cluster)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
  ) extends zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly {
    override val cluster: Optional[zio.aws.redshift.model.Cluster.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cluster())
        .map(value => zio.aws.redshift.model.Cluster.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterMaintenanceResponse
  ): zio.aws.redshift.model.ModifyClusterMaintenanceResponse.ReadOnly =
    new Wrapper(impl)
}
