package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyClusterDbRevisionRequest(
    clusterIdentifier: String,
    revisionTarget: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest = {
    import ModifyClusterDbRevisionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .revisionTarget(revisionTarget: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyClusterDbRevisionRequest.ReadOnly =
    zio.aws.redshift.model.ModifyClusterDbRevisionRequest.wrap(buildAwsValue())
}
object ModifyClusterDbRevisionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyClusterDbRevisionRequest =
      zio.aws.redshift.model
        .ModifyClusterDbRevisionRequest(clusterIdentifier, revisionTarget)
    def clusterIdentifier: String
    def revisionTarget: String
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getRevisionTarget: ZIO[Any, Nothing, String] =
      ZIO.succeed(revisionTarget)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest
  ) extends zio.aws.redshift.model.ModifyClusterDbRevisionRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val revisionTarget: String = impl.revisionTarget(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyClusterDbRevisionRequest
  ): zio.aws.redshift.model.ModifyClusterDbRevisionRequest.ReadOnly =
    new Wrapper(impl)
}
