package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ModifyAquaConfigurationRequest(
    clusterIdentifier: String,
    aquaConfigurationStatus: Optional[
      zio.aws.redshift.model.AquaConfigurationStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest = {
    import ModifyAquaConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest
      .builder()
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(aquaConfigurationStatus.map(value => value.unwrap))(
        _.aquaConfigurationStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.ModifyAquaConfigurationRequest.ReadOnly =
    zio.aws.redshift.model.ModifyAquaConfigurationRequest.wrap(buildAwsValue())
}
object ModifyAquaConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ModifyAquaConfigurationRequest =
      zio.aws.redshift.model.ModifyAquaConfigurationRequest(
        clusterIdentifier,
        aquaConfigurationStatus.map(value => value)
      )
    def clusterIdentifier: String
    def aquaConfigurationStatus
        : Optional[zio.aws.redshift.model.AquaConfigurationStatus]
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getAquaConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AquaConfigurationStatus] =
      AwsError.unwrapOptionField(
        "aquaConfigurationStatus",
        aquaConfigurationStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest
  ) extends zio.aws.redshift.model.ModifyAquaConfigurationRequest.ReadOnly {
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val aquaConfigurationStatus
        : Optional[zio.aws.redshift.model.AquaConfigurationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aquaConfigurationStatus())
        .map(value =>
          zio.aws.redshift.model.AquaConfigurationStatus.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ModifyAquaConfigurationRequest
  ): zio.aws.redshift.model.ModifyAquaConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
