package zio.aws.redshift.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.redshift.model.primitives.TStamp
import scala.jdk.CollectionConverters._
final case class DisableLoggingResponse(
    loggingEnabled: Optional[Boolean] = Optional.Absent,
    bucketName: Optional[String] = Optional.Absent,
    s3KeyPrefix: Optional[String] = Optional.Absent,
    lastSuccessfulDeliveryTime: Optional[TStamp] = Optional.Absent,
    lastFailureTime: Optional[TStamp] = Optional.Absent,
    lastFailureMessage: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DisableLoggingResponse = {
    import DisableLoggingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
      .builder()
      .optionallyWith(loggingEnabled.map(value => value: java.lang.Boolean))(
        _.loggingEnabled
      )
      .optionallyWith(bucketName.map(value => value: java.lang.String))(
        _.bucketName
      )
      .optionallyWith(s3KeyPrefix.map(value => value: java.lang.String))(
        _.s3KeyPrefix
      )
      .optionallyWith(
        lastSuccessfulDeliveryTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastSuccessfulDeliveryTime)
      .optionallyWith(
        lastFailureTime.map(value => TStamp.unwrap(value): Instant)
      )(_.lastFailureTime)
      .optionallyWith(lastFailureMessage.map(value => value: java.lang.String))(
        _.lastFailureMessage
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DisableLoggingResponse.ReadOnly =
    zio.aws.redshift.model.DisableLoggingResponse.wrap(buildAwsValue())
}
object DisableLoggingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DisableLoggingResponse =
      zio.aws.redshift.model.DisableLoggingResponse(
        loggingEnabled.map(value => value),
        bucketName.map(value => value),
        s3KeyPrefix.map(value => value),
        lastSuccessfulDeliveryTime.map(value => value),
        lastFailureTime.map(value => value),
        lastFailureMessage.map(value => value)
      )
    def loggingEnabled: Optional[Boolean]
    def bucketName: Optional[String]
    def s3KeyPrefix: Optional[String]
    def lastSuccessfulDeliveryTime: Optional[TStamp]
    def lastFailureTime: Optional[TStamp]
    def lastFailureMessage: Optional[String]
    def getLoggingEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("loggingEnabled", loggingEnabled)
    def getBucketName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bucketName", bucketName)
    def getS3KeyPrefix: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("s3KeyPrefix", s3KeyPrefix)
    def getLastSuccessfulDeliveryTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField(
        "lastSuccessfulDeliveryTime",
        lastSuccessfulDeliveryTime
      )
    def getLastFailureTime: ZIO[Any, AwsError, TStamp] =
      AwsError.unwrapOptionField("lastFailureTime", lastFailureTime)
    def getLastFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastFailureMessage", lastFailureMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
  ) extends zio.aws.redshift.model.DisableLoggingResponse.ReadOnly {
    override val loggingEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingEnabled())
      .map(value => value: Boolean)
    override val bucketName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.bucketName())
      .map(value => value: String)
    override val s3KeyPrefix: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.s3KeyPrefix())
      .map(value => value: String)
    override val lastSuccessfulDeliveryTime: Optional[TStamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastSuccessfulDeliveryTime())
        .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val lastFailureTime: Optional[TStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureTime())
      .map(value => zio.aws.redshift.model.primitives.TStamp(value))
    override val lastFailureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.lastFailureMessage())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DisableLoggingResponse
  ): zio.aws.redshift.model.DisableLoggingResponse.ReadOnly = new Wrapper(impl)
}
