package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesRequest(
    sourceType: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest = {
    import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEventCategoriesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEventCategoriesRequest.wrap(buildAwsValue())
}
object DescribeEventCategoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEventCategoriesRequest =
      zio.aws.redshift.model
        .DescribeEventCategoriesRequest(sourceType.map(value => value))
    def sourceType: Optional[String]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
  ) extends zio.aws.redshift.model.DescribeEventCategoriesRequest.ReadOnly {
    override val sourceType: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceType())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
  ): zio.aws.redshift.model.DescribeEventCategoriesRequest.ReadOnly =
    new Wrapper(impl)
}
