package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Subnet(
    subnetIdentifier: Option[String] = None,
    subnetAvailabilityZone: Option[zio.aws.redshift.model.AvailabilityZone] =
      None,
    subnetStatus: Option[String] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.redshift.model.Subnet = {
    import Subnet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.Subnet
      .builder()
      .optionallyWith(subnetIdentifier.map(value => value: java.lang.String))(
        _.subnetIdentifier
      )
      .optionallyWith(
        subnetAvailabilityZone.map(value => value.buildAwsValue())
      )(_.subnetAvailabilityZone)
      .optionallyWith(subnetStatus.map(value => value: java.lang.String))(
        _.subnetStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.Subnet.ReadOnly =
    zio.aws.redshift.model.Subnet.wrap(buildAwsValue())
}
object Subnet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.redshift.model.Subnet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.Subnet =
      zio.aws.redshift.model.Subnet(
        subnetIdentifier.map(value => value),
        subnetAvailabilityZone.map(value => value.asEditable),
        subnetStatus.map(value => value)
      )
    def subnetIdentifier: Option[String]
    def subnetAvailabilityZone
        : Option[zio.aws.redshift.model.AvailabilityZone.ReadOnly]
    def subnetStatus: Option[String]
    def getSubnetIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetIdentifier", subnetIdentifier)
    def getSubnetAvailabilityZone
        : ZIO[Any, AwsError, zio.aws.redshift.model.AvailabilityZone.ReadOnly] =
      AwsError.unwrapOptionField(
        "subnetAvailabilityZone",
        subnetAvailabilityZone
      )
    def getSubnetStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("subnetStatus", subnetStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.Subnet
  ) extends zio.aws.redshift.model.Subnet.ReadOnly {
    override val subnetIdentifier: Option[String] =
      scala.Option(impl.subnetIdentifier()).map(value => value: String)
    override val subnetAvailabilityZone
        : Option[zio.aws.redshift.model.AvailabilityZone.ReadOnly] = scala
      .Option(impl.subnetAvailabilityZone())
      .map(value => zio.aws.redshift.model.AvailabilityZone.wrap(value))
    override val subnetStatus: Option[String] =
      scala.Option(impl.subnetStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.Subnet
  ): zio.aws.redshift.model.Subnet.ReadOnly = new Wrapper(impl)
}
