package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeReservedNodesResponse(
    marker: Option[String] = None,
    reservedNodes: Option[Iterable[zio.aws.redshift.model.ReservedNode]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse = {
    import DescribeReservedNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        reservedNodes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.reservedNodes)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeReservedNodesResponse.wrap(buildAwsValue())
}
object DescribeReservedNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeReservedNodesResponse =
      zio.aws.redshift.model.DescribeReservedNodesResponse(
        marker.map(value => value),
        reservedNodes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def reservedNodes
        : Option[List[zio.aws.redshift.model.ReservedNode.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getReservedNodes: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.ReservedNode.ReadOnly
    ]] = AwsError.unwrapOptionField("reservedNodes", reservedNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse
  ) extends zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val reservedNodes
        : Option[List[zio.aws.redshift.model.ReservedNode.ReadOnly]] = scala
      .Option(impl.reservedNodes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.ReservedNode.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeReservedNodesResponse
  ): zio.aws.redshift.model.DescribeReservedNodesResponse.ReadOnly =
    new Wrapper(impl)
}
