package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHsmClientCertificatesResponse(
    marker: Option[String] = None,
    hsmClientCertificates: Option[
      Iterable[zio.aws.redshift.model.HsmClientCertificate]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse = {
    import DescribeHsmClientCertificatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        hsmClientCertificates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hsmClientCertificates)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeHsmClientCertificatesResponse
      .wrap(buildAwsValue())
}
object DescribeHsmClientCertificatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeHsmClientCertificatesResponse =
      zio.aws.redshift.model.DescribeHsmClientCertificatesResponse(
        marker.map(value => value),
        hsmClientCertificates.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def hsmClientCertificates
        : Option[List[zio.aws.redshift.model.HsmClientCertificate.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getHsmClientCertificates: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.HsmClientCertificate.ReadOnly
    ]] =
      AwsError.unwrapOptionField("hsmClientCertificates", hsmClientCertificates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
  ) extends zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val hsmClientCertificates
        : Option[List[zio.aws.redshift.model.HsmClientCertificate.ReadOnly]] =
      scala
        .Option(impl.hsmClientCertificates())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.HsmClientCertificate.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmClientCertificatesResponse
  ): zio.aws.redshift.model.DescribeHsmClientCertificatesResponse.ReadOnly =
    new Wrapper(impl)
}
