package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventsResponse(
    marker: Option[String] = None,
    events: Option[Iterable[zio.aws.redshift.model.Event]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEventsResponse = {
    import DescribeEventsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEventsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.events)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.DescribeEventsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeEventsResponse.wrap(buildAwsValue())
}
object DescribeEventsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEventsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEventsResponse =
      zio.aws.redshift.model.DescribeEventsResponse(
        marker.map(value => value),
        events.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def events: Option[List[zio.aws.redshift.model.Event.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getEvents
        : ZIO[Any, AwsError, List[zio.aws.redshift.model.Event.ReadOnly]] =
      AwsError.unwrapOptionField("events", events)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventsResponse
  ) extends zio.aws.redshift.model.DescribeEventsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val events: Option[List[zio.aws.redshift.model.Event.ReadOnly]] =
      scala
        .Option(impl.events())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.Event.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventsResponse
  ): zio.aws.redshift.model.DescribeEventsResponse.ReadOnly = new Wrapper(impl)
}
