package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesRequest(
    sourceType: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest = {
    import DescribeEventCategoriesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
      .builder()
      .optionallyWith(sourceType.map(value => value: java.lang.String))(
        _.sourceType
      )
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEventCategoriesRequest.ReadOnly =
    zio.aws.redshift.model.DescribeEventCategoriesRequest.wrap(buildAwsValue())
}
object DescribeEventCategoriesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEventCategoriesRequest =
      zio.aws.redshift.model
        .DescribeEventCategoriesRequest(sourceType.map(value => value))
    def sourceType: Option[String]
    def getSourceType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceType", sourceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
  ) extends zio.aws.redshift.model.DescribeEventCategoriesRequest.ReadOnly {
    override val sourceType: Option[String] =
      scala.Option(impl.sourceType()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesRequest
  ): zio.aws.redshift.model.DescribeEventCategoriesRequest.ReadOnly =
    new Wrapper(impl)
}
