package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAuthenticationProfilesResponse(
    authenticationProfiles: Option[
      Iterable[zio.aws.redshift.model.AuthenticationProfile]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse = {
    import DescribeAuthenticationProfilesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse
      .builder()
      .optionallyWith(
        authenticationProfiles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.authenticationProfiles)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeAuthenticationProfilesResponse
      .wrap(buildAwsValue())
}
object DescribeAuthenticationProfilesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.redshift.model.DescribeAuthenticationProfilesResponse =
      zio.aws.redshift.model.DescribeAuthenticationProfilesResponse(
        authenticationProfiles.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def authenticationProfiles
        : Option[List[zio.aws.redshift.model.AuthenticationProfile.ReadOnly]]
    def getAuthenticationProfiles: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.AuthenticationProfile.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "authenticationProfiles",
      authenticationProfiles
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse
  ) extends zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly {
    override val authenticationProfiles
        : Option[List[zio.aws.redshift.model.AuthenticationProfile.ReadOnly]] =
      scala
        .Option(impl.authenticationProfiles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.AuthenticationProfile.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeAuthenticationProfilesResponse
  ): zio.aws.redshift.model.DescribeAuthenticationProfilesResponse.ReadOnly =
    new Wrapper(impl)
}
