package zio.aws.redshift.model
import java.lang.Integer
import zio.aws.redshift.model.primitives.{BooleanOptional, IntegerOptional}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterRequest(
    dbName: Option[String] = None,
    clusterIdentifier: String,
    clusterType: Option[String] = None,
    nodeType: String,
    masterUsername: String,
    masterUserPassword: String,
    clusterSecurityGroups: Option[Iterable[String]] = None,
    vpcSecurityGroupIds: Option[Iterable[String]] = None,
    clusterSubnetGroupName: Option[String] = None,
    availabilityZone: Option[String] = None,
    preferredMaintenanceWindow: Option[String] = None,
    clusterParameterGroupName: Option[String] = None,
    automatedSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    manualSnapshotRetentionPeriod: Option[IntegerOptional] = None,
    port: Option[IntegerOptional] = None,
    clusterVersion: Option[String] = None,
    allowVersionUpgrade: Option[BooleanOptional] = None,
    numberOfNodes: Option[IntegerOptional] = None,
    publiclyAccessible: Option[BooleanOptional] = None,
    encrypted: Option[BooleanOptional] = None,
    hsmClientCertificateIdentifier: Option[String] = None,
    hsmConfigurationIdentifier: Option[String] = None,
    elasticIp: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None,
    kmsKeyId: Option[String] = None,
    enhancedVpcRouting: Option[BooleanOptional] = None,
    additionalInfo: Option[String] = None,
    iamRoles: Option[Iterable[String]] = None,
    maintenanceTrackName: Option[String] = None,
    snapshotScheduleIdentifier: Option[String] = None,
    availabilityZoneRelocation: Option[BooleanOptional] = None,
    aquaConfigurationStatus: Option[
      zio.aws.redshift.model.AquaConfigurationStatus
    ] = None,
    defaultIamRoleArn: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterRequest = {
    import CreateClusterRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterRequest
      .builder()
      .optionallyWith(dbName.map(value => value: java.lang.String))(_.dbName)
      .clusterIdentifier(clusterIdentifier: java.lang.String)
      .optionallyWith(clusterType.map(value => value: java.lang.String))(
        _.clusterType
      )
      .nodeType(nodeType: java.lang.String)
      .masterUsername(masterUsername: java.lang.String)
      .masterUserPassword(masterUserPassword: java.lang.String)
      .optionallyWith(
        clusterSecurityGroups.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.clusterSecurityGroups)
      .optionallyWith(
        vpcSecurityGroupIds.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.vpcSecurityGroupIds)
      .optionallyWith(
        clusterSubnetGroupName.map(value => value: java.lang.String)
      )(_.clusterSubnetGroupName)
      .optionallyWith(availabilityZone.map(value => value: java.lang.String))(
        _.availabilityZone
      )
      .optionallyWith(
        preferredMaintenanceWindow.map(value => value: java.lang.String)
      )(_.preferredMaintenanceWindow)
      .optionallyWith(
        clusterParameterGroupName.map(value => value: java.lang.String)
      )(_.clusterParameterGroupName)
      .optionallyWith(
        automatedSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.automatedSnapshotRetentionPeriod)
      .optionallyWith(
        manualSnapshotRetentionPeriod.map(value => value: Integer)
      )(_.manualSnapshotRetentionPeriod)
      .optionallyWith(port.map(value => value: Integer))(_.port)
      .optionallyWith(clusterVersion.map(value => value: java.lang.String))(
        _.clusterVersion
      )
      .optionallyWith(
        allowVersionUpgrade.map(value => value: java.lang.Boolean)
      )(_.allowVersionUpgrade)
      .optionallyWith(numberOfNodes.map(value => value: Integer))(
        _.numberOfNodes
      )
      .optionallyWith(
        publiclyAccessible.map(value => value: java.lang.Boolean)
      )(_.publiclyAccessible)
      .optionallyWith(encrypted.map(value => value: java.lang.Boolean))(
        _.encrypted
      )
      .optionallyWith(
        hsmClientCertificateIdentifier.map(value => value: java.lang.String)
      )(_.hsmClientCertificateIdentifier)
      .optionallyWith(
        hsmConfigurationIdentifier.map(value => value: java.lang.String)
      )(_.hsmConfigurationIdentifier)
      .optionallyWith(elasticIp.map(value => value: java.lang.String))(
        _.elasticIp
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        enhancedVpcRouting.map(value => value: java.lang.Boolean)
      )(_.enhancedVpcRouting)
      .optionallyWith(additionalInfo.map(value => value: java.lang.String))(
        _.additionalInfo
      )
      .optionallyWith(
        iamRoles.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.iamRoles)
      .optionallyWith(
        maintenanceTrackName.map(value => value: java.lang.String)
      )(_.maintenanceTrackName)
      .optionallyWith(
        snapshotScheduleIdentifier.map(value => value: java.lang.String)
      )(_.snapshotScheduleIdentifier)
      .optionallyWith(
        availabilityZoneRelocation.map(value => value: java.lang.Boolean)
      )(_.availabilityZoneRelocation)
      .optionallyWith(aquaConfigurationStatus.map(value => value.unwrap))(
        _.aquaConfigurationStatus
      )
      .optionallyWith(defaultIamRoleArn.map(value => value: java.lang.String))(
        _.defaultIamRoleArn
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.CreateClusterRequest.ReadOnly =
    zio.aws.redshift.model.CreateClusterRequest.wrap(buildAwsValue())
}
object CreateClusterRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterRequest =
      zio.aws.redshift.model.CreateClusterRequest(
        dbName.map(value => value),
        clusterIdentifier,
        clusterType.map(value => value),
        nodeType,
        masterUsername,
        masterUserPassword,
        clusterSecurityGroups.map(value => value),
        vpcSecurityGroupIds.map(value => value),
        clusterSubnetGroupName.map(value => value),
        availabilityZone.map(value => value),
        preferredMaintenanceWindow.map(value => value),
        clusterParameterGroupName.map(value => value),
        automatedSnapshotRetentionPeriod.map(value => value),
        manualSnapshotRetentionPeriod.map(value => value),
        port.map(value => value),
        clusterVersion.map(value => value),
        allowVersionUpgrade.map(value => value),
        numberOfNodes.map(value => value),
        publiclyAccessible.map(value => value),
        encrypted.map(value => value),
        hsmClientCertificateIdentifier.map(value => value),
        hsmConfigurationIdentifier.map(value => value),
        elasticIp.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKeyId.map(value => value),
        enhancedVpcRouting.map(value => value),
        additionalInfo.map(value => value),
        iamRoles.map(value => value),
        maintenanceTrackName.map(value => value),
        snapshotScheduleIdentifier.map(value => value),
        availabilityZoneRelocation.map(value => value),
        aquaConfigurationStatus.map(value => value),
        defaultIamRoleArn.map(value => value)
      )
    def dbName: Option[String]
    def clusterIdentifier: String
    def clusterType: Option[String]
    def nodeType: String
    def masterUsername: String
    def masterUserPassword: String
    def clusterSecurityGroups: Option[List[String]]
    def vpcSecurityGroupIds: Option[List[String]]
    def clusterSubnetGroupName: Option[String]
    def availabilityZone: Option[String]
    def preferredMaintenanceWindow: Option[String]
    def clusterParameterGroupName: Option[String]
    def automatedSnapshotRetentionPeriod: Option[IntegerOptional]
    def manualSnapshotRetentionPeriod: Option[IntegerOptional]
    def port: Option[IntegerOptional]
    def clusterVersion: Option[String]
    def allowVersionUpgrade: Option[BooleanOptional]
    def numberOfNodes: Option[IntegerOptional]
    def publiclyAccessible: Option[BooleanOptional]
    def encrypted: Option[BooleanOptional]
    def hsmClientCertificateIdentifier: Option[String]
    def hsmConfigurationIdentifier: Option[String]
    def elasticIp: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def kmsKeyId: Option[String]
    def enhancedVpcRouting: Option[BooleanOptional]
    def additionalInfo: Option[String]
    def iamRoles: Option[List[String]]
    def maintenanceTrackName: Option[String]
    def snapshotScheduleIdentifier: Option[String]
    def availabilityZoneRelocation: Option[BooleanOptional]
    def aquaConfigurationStatus
        : Option[zio.aws.redshift.model.AquaConfigurationStatus]
    def defaultIamRoleArn: Option[String]
    def getDbName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("dbName", dbName)
    def getClusterIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(clusterIdentifier)
    def getClusterType: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterType", clusterType)
    def getNodeType: ZIO[Any, Nothing, String] = ZIO.succeed(nodeType)
    def getMasterUsername: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUsername)
    def getMasterUserPassword: ZIO[Any, Nothing, String] =
      ZIO.succeed(masterUserPassword)
    def getClusterSecurityGroups: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("clusterSecurityGroups", clusterSecurityGroups)
    def getVpcSecurityGroupIds: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("vpcSecurityGroupIds", vpcSecurityGroupIds)
    def getClusterSubnetGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterSubnetGroupName", clusterSubnetGroupName)
    def getAvailabilityZone: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getPreferredMaintenanceWindow: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "preferredMaintenanceWindow",
        preferredMaintenanceWindow
      )
    def getClusterParameterGroupName: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("clusterParameterGroupName", clusterParameterGroupName)
    def getAutomatedSnapshotRetentionPeriod
        : ZIO[Any, AwsError, IntegerOptional] = AwsError.unwrapOptionField(
      "automatedSnapshotRetentionPeriod",
      automatedSnapshotRetentionPeriod
    )
    def getManualSnapshotRetentionPeriod: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField(
        "manualSnapshotRetentionPeriod",
        manualSnapshotRetentionPeriod
      )
    def getPort: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("port", port)
    def getClusterVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clusterVersion", clusterVersion)
    def getAllowVersionUpgrade: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("allowVersionUpgrade", allowVersionUpgrade)
    def getNumberOfNodes: ZIO[Any, AwsError, IntegerOptional] =
      AwsError.unwrapOptionField("numberOfNodes", numberOfNodes)
    def getPubliclyAccessible: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("publiclyAccessible", publiclyAccessible)
    def getEncrypted: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getHsmClientCertificateIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmClientCertificateIdentifier",
        hsmClientCertificateIdentifier
      )
    def getHsmConfigurationIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "hsmConfigurationIdentifier",
        hsmConfigurationIdentifier
      )
    def getElasticIp: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("elasticIp", elasticIp)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getEnhancedVpcRouting: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField("enhancedVpcRouting", enhancedVpcRouting)
    def getAdditionalInfo: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("additionalInfo", additionalInfo)
    def getIamRoles: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("iamRoles", iamRoles)
    def getMaintenanceTrackName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("maintenanceTrackName", maintenanceTrackName)
    def getSnapshotScheduleIdentifier: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "snapshotScheduleIdentifier",
        snapshotScheduleIdentifier
      )
    def getAvailabilityZoneRelocation: ZIO[Any, AwsError, BooleanOptional] =
      AwsError.unwrapOptionField(
        "availabilityZoneRelocation",
        availabilityZoneRelocation
      )
    def getAquaConfigurationStatus
        : ZIO[Any, AwsError, zio.aws.redshift.model.AquaConfigurationStatus] =
      AwsError.unwrapOptionField(
        "aquaConfigurationStatus",
        aquaConfigurationStatus
      )
    def getDefaultIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("defaultIamRoleArn", defaultIamRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterRequest
  ) extends zio.aws.redshift.model.CreateClusterRequest.ReadOnly {
    override val dbName: Option[String] =
      scala.Option(impl.dbName()).map(value => value: String)
    override val clusterIdentifier: String = impl.clusterIdentifier(): String
    override val clusterType: Option[String] =
      scala.Option(impl.clusterType()).map(value => value: String)
    override val nodeType: String = impl.nodeType(): String
    override val masterUsername: String = impl.masterUsername(): String
    override val masterUserPassword: String = impl.masterUserPassword(): String
    override val clusterSecurityGroups: Option[List[String]] = scala
      .Option(impl.clusterSecurityGroups())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val vpcSecurityGroupIds: Option[List[String]] = scala
      .Option(impl.vpcSecurityGroupIds())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val clusterSubnetGroupName: Option[String] =
      scala.Option(impl.clusterSubnetGroupName()).map(value => value: String)
    override val availabilityZone: Option[String] =
      scala.Option(impl.availabilityZone()).map(value => value: String)
    override val preferredMaintenanceWindow: Option[String] = scala
      .Option(impl.preferredMaintenanceWindow())
      .map(value => value: String)
    override val clusterParameterGroupName: Option[String] =
      scala.Option(impl.clusterParameterGroupName()).map(value => value: String)
    override val automatedSnapshotRetentionPeriod: Option[IntegerOptional] =
      scala
        .Option(impl.automatedSnapshotRetentionPeriod())
        .map(value => value: IntegerOptional)
    override val manualSnapshotRetentionPeriod: Option[IntegerOptional] = scala
      .Option(impl.manualSnapshotRetentionPeriod())
      .map(value => value: IntegerOptional)
    override val port: Option[IntegerOptional] =
      scala.Option(impl.port()).map(value => value: IntegerOptional)
    override val clusterVersion: Option[String] =
      scala.Option(impl.clusterVersion()).map(value => value: String)
    override val allowVersionUpgrade: Option[BooleanOptional] = scala
      .Option(impl.allowVersionUpgrade())
      .map(value => value: BooleanOptional)
    override val numberOfNodes: Option[IntegerOptional] =
      scala.Option(impl.numberOfNodes()).map(value => value: IntegerOptional)
    override val publiclyAccessible: Option[BooleanOptional] = scala
      .Option(impl.publiclyAccessible())
      .map(value => value: BooleanOptional)
    override val encrypted: Option[BooleanOptional] =
      scala.Option(impl.encrypted()).map(value => value: BooleanOptional)
    override val hsmClientCertificateIdentifier: Option[String] = scala
      .Option(impl.hsmClientCertificateIdentifier())
      .map(value => value: String)
    override val hsmConfigurationIdentifier: Option[String] = scala
      .Option(impl.hsmConfigurationIdentifier())
      .map(value => value: String)
    override val elasticIp: Option[String] =
      scala.Option(impl.elasticIp()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val enhancedVpcRouting: Option[BooleanOptional] = scala
      .Option(impl.enhancedVpcRouting())
      .map(value => value: BooleanOptional)
    override val additionalInfo: Option[String] =
      scala.Option(impl.additionalInfo()).map(value => value: String)
    override val iamRoles: Option[List[String]] = scala
      .Option(impl.iamRoles())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val maintenanceTrackName: Option[String] =
      scala.Option(impl.maintenanceTrackName()).map(value => value: String)
    override val snapshotScheduleIdentifier: Option[String] = scala
      .Option(impl.snapshotScheduleIdentifier())
      .map(value => value: String)
    override val availabilityZoneRelocation: Option[BooleanOptional] = scala
      .Option(impl.availabilityZoneRelocation())
      .map(value => value: BooleanOptional)
    override val aquaConfigurationStatus
        : Option[zio.aws.redshift.model.AquaConfigurationStatus] = scala
      .Option(impl.aquaConfigurationStatus())
      .map(value => zio.aws.redshift.model.AquaConfigurationStatus.wrap(value))
    override val defaultIamRoleArn: Option[String] =
      scala.Option(impl.defaultIamRoleArn()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterRequest
  ): zio.aws.redshift.model.CreateClusterRequest.ReadOnly = new Wrapper(impl)
}
