package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateClusterParameterGroupRequest(
    parameterGroupName: String,
    parameterGroupFamily: String,
    description: String,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest = {
    import CreateClusterParameterGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest
      .builder()
      .parameterGroupName(parameterGroupName: java.lang.String)
      .parameterGroupFamily(parameterGroupFamily: java.lang.String)
      .description(description: java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateClusterParameterGroupRequest.ReadOnly =
    zio.aws.redshift.model.CreateClusterParameterGroupRequest
      .wrap(buildAwsValue())
}
object CreateClusterParameterGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateClusterParameterGroupRequest =
      zio.aws.redshift.model.CreateClusterParameterGroupRequest(
        parameterGroupName,
        parameterGroupFamily,
        description,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def parameterGroupName: String
    def parameterGroupFamily: String
    def description: String
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getParameterGroupName: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupName)
    def getParameterGroupFamily: ZIO[Any, Nothing, String] =
      ZIO.succeed(parameterGroupFamily)
    def getDescription: ZIO[Any, Nothing, String] = ZIO.succeed(description)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest
  ) extends zio.aws.redshift.model.CreateClusterParameterGroupRequest.ReadOnly {
    override val parameterGroupName: String = impl.parameterGroupName(): String
    override val parameterGroupFamily: String =
      impl.parameterGroupFamily(): String
    override val description: String = impl.description(): String
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateClusterParameterGroupRequest
  ): zio.aws.redshift.model.CreateClusterParameterGroupRequest.ReadOnly =
    new Wrapper(impl)
}
