package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ClusterIamRole(
    iamRoleArn: Option[String] = None,
    applyStatus: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.ClusterIamRole = {
    import ClusterIamRole.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.ClusterIamRole
      .builder()
      .optionallyWith(iamRoleArn.map(value => value: java.lang.String))(
        _.iamRoleArn
      )
      .optionallyWith(applyStatus.map(value => value: java.lang.String))(
        _.applyStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.ClusterIamRole.ReadOnly =
    zio.aws.redshift.model.ClusterIamRole.wrap(buildAwsValue())
}
object ClusterIamRole {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.ClusterIamRole
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.ClusterIamRole =
      zio.aws.redshift.model.ClusterIamRole(
        iamRoleArn.map(value => value),
        applyStatus.map(value => value)
      )
    def iamRoleArn: Option[String]
    def applyStatus: Option[String]
    def getIamRoleArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
    def getApplyStatus: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("applyStatus", applyStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.ClusterIamRole
  ) extends zio.aws.redshift.model.ClusterIamRole.ReadOnly {
    override val iamRoleArn: Option[String] =
      scala.Option(impl.iamRoleArn()).map(value => value: String)
    override val applyStatus: Option[String] =
      scala.Option(impl.applyStatus()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.ClusterIamRole
  ): zio.aws.redshift.model.ClusterIamRole.ReadOnly = new Wrapper(impl)
}
