package zio.aws.redshift.model
import zio.aws.redshift.model.primitives.AuthenticationProfileNameString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthenticationProfile(
    authenticationProfileName: Option[AuthenticationProfileNameString] = None,
    authenticationProfileContent: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.AuthenticationProfile = {
    import AuthenticationProfile.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.AuthenticationProfile
      .builder()
      .optionallyWith(
        authenticationProfileName.map(value =>
          AuthenticationProfileNameString.unwrap(value): java.lang.String
        )
      )(_.authenticationProfileName)
      .optionallyWith(
        authenticationProfileContent.map(value => value: java.lang.String)
      )(_.authenticationProfileContent)
      .build()
  }
  def asReadOnly: zio.aws.redshift.model.AuthenticationProfile.ReadOnly =
    zio.aws.redshift.model.AuthenticationProfile.wrap(buildAwsValue())
}
object AuthenticationProfile {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.AuthenticationProfile
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.AuthenticationProfile =
      zio.aws.redshift.model.AuthenticationProfile(
        authenticationProfileName.map(value => value),
        authenticationProfileContent.map(value => value)
      )
    def authenticationProfileName: Option[AuthenticationProfileNameString]
    def authenticationProfileContent: Option[String]
    def getAuthenticationProfileName
        : ZIO[Any, AwsError, AuthenticationProfileNameString] = AwsError
      .unwrapOptionField("authenticationProfileName", authenticationProfileName)
    def getAuthenticationProfileContent: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "authenticationProfileContent",
        authenticationProfileContent
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.AuthenticationProfile
  ) extends zio.aws.redshift.model.AuthenticationProfile.ReadOnly {
    override val authenticationProfileName
        : Option[AuthenticationProfileNameString] = scala
      .Option(impl.authenticationProfileName())
      .map(value =>
        zio.aws.redshift.model.primitives.AuthenticationProfileNameString(value)
      )
    override val authenticationProfileContent: Option[String] = scala
      .Option(impl.authenticationProfileContent())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.AuthenticationProfile
  ): zio.aws.redshift.model.AuthenticationProfile.ReadOnly = new Wrapper(impl)
}
