package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class NodeConfigurationOptionsFilter(
    name: Option[zio.aws.redshift.model.NodeConfigurationOptionsFilterName] =
      None,
    operator: Option[zio.aws.redshift.model.OperatorType] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter = {
    import NodeConfigurationOptionsFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(operator.map(value => value.unwrap))(_.operator)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly =
    zio.aws.redshift.model.NodeConfigurationOptionsFilter.wrap(buildAwsValue())
}
object NodeConfigurationOptionsFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.NodeConfigurationOptionsFilter =
      zio.aws.redshift.model.NodeConfigurationOptionsFilter(
        name.map(value => value),
        operator.map(value => value),
        values.map(value => value)
      )
    def name: Option[zio.aws.redshift.model.NodeConfigurationOptionsFilterName]
    def operator: Option[zio.aws.redshift.model.OperatorType]
    def values: Option[List[String]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.redshift.model.NodeConfigurationOptionsFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getOperator: ZIO[Any, AwsError, zio.aws.redshift.model.OperatorType] =
      AwsError.unwrapOptionField("operator", operator)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter
  ) extends zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly {
    override val name
        : Option[zio.aws.redshift.model.NodeConfigurationOptionsFilterName] =
      scala
        .Option(impl.name())
        .map(value =>
          zio.aws.redshift.model.NodeConfigurationOptionsFilterName.wrap(value)
        )
    override val operator: Option[zio.aws.redshift.model.OperatorType] = scala
      .Option(impl.operator())
      .map(value => zio.aws.redshift.model.OperatorType.wrap(value))
    override val values: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.NodeConfigurationOptionsFilter
  ): zio.aws.redshift.model.NodeConfigurationOptionsFilter.ReadOnly =
    new Wrapper(impl)
}
