package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeHsmConfigurationsResponse(
    marker: Option[String] = None,
    hsmConfigurations: Option[
      Iterable[zio.aws.redshift.model.HsmConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse = {
    import DescribeHsmConfigurationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse
      .builder()
      .optionallyWith(marker.map(value => value: java.lang.String))(_.marker)
      .optionallyWith(
        hsmConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hsmConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly =
    zio.aws.redshift.model.DescribeHsmConfigurationsResponse
      .wrap(buildAwsValue())
}
object DescribeHsmConfigurationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeHsmConfigurationsResponse =
      zio.aws.redshift.model.DescribeHsmConfigurationsResponse(
        marker.map(value => value),
        hsmConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def marker: Option[String]
    def hsmConfigurations
        : Option[List[zio.aws.redshift.model.HsmConfiguration.ReadOnly]]
    def getMarker: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("marker", marker)
    def getHsmConfigurations: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.HsmConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("hsmConfigurations", hsmConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse
  ) extends zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly {
    override val marker: Option[String] =
      scala.Option(impl.marker()).map(value => value: String)
    override val hsmConfigurations
        : Option[List[zio.aws.redshift.model.HsmConfiguration.ReadOnly]] = scala
      .Option(impl.hsmConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.HsmConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeHsmConfigurationsResponse
  ): zio.aws.redshift.model.DescribeHsmConfigurationsResponse.ReadOnly =
    new Wrapper(impl)
}
