package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeEventCategoriesResponse(
    eventCategoriesMapList: Option[
      Iterable[zio.aws.redshift.model.EventCategoriesMap]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse = {
    import DescribeEventCategoriesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse
      .builder()
      .optionallyWith(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventCategoriesMapList)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly =
    zio.aws.redshift.model.DescribeEventCategoriesResponse.wrap(buildAwsValue())
}
object DescribeEventCategoriesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.DescribeEventCategoriesResponse =
      zio.aws.redshift.model.DescribeEventCategoriesResponse(
        eventCategoriesMapList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def eventCategoriesMapList
        : Option[List[zio.aws.redshift.model.EventCategoriesMap.ReadOnly]]
    def getEventCategoriesMapList: ZIO[Any, AwsError, List[
      zio.aws.redshift.model.EventCategoriesMap.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "eventCategoriesMapList",
      eventCategoriesMapList
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse
  ) extends zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly {
    override val eventCategoriesMapList
        : Option[List[zio.aws.redshift.model.EventCategoriesMap.ReadOnly]] =
      scala
        .Option(impl.eventCategoriesMapList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.redshift.model.EventCategoriesMap.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.DescribeEventCategoriesResponse
  ): zio.aws.redshift.model.DescribeEventCategoriesResponse.ReadOnly =
    new Wrapper(impl)
}
