package zio.aws.redshift.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateSnapshotCopyGrantRequest(
    snapshotCopyGrantName: String,
    kmsKeyId: Option[String] = None,
    tags: Option[Iterable[zio.aws.redshift.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest = {
    import CreateSnapshotCopyGrantRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest
      .builder()
      .snapshotCopyGrantName(snapshotCopyGrantName: java.lang.String)
      .optionallyWith(kmsKeyId.map(value => value: java.lang.String))(
        _.kmsKeyId
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.redshift.model.CreateSnapshotCopyGrantRequest.ReadOnly =
    zio.aws.redshift.model.CreateSnapshotCopyGrantRequest.wrap(buildAwsValue())
}
object CreateSnapshotCopyGrantRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.redshift.model.CreateSnapshotCopyGrantRequest =
      zio.aws.redshift.model.CreateSnapshotCopyGrantRequest(
        snapshotCopyGrantName,
        kmsKeyId.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def snapshotCopyGrantName: String
    def kmsKeyId: Option[String]
    def tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]]
    def getSnapshotCopyGrantName: ZIO[Any, Nothing, String] =
      ZIO.succeed(snapshotCopyGrantName)
    def getKmsKeyId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
    def getTags: ZIO[Any, AwsError, List[zio.aws.redshift.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest
  ) extends zio.aws.redshift.model.CreateSnapshotCopyGrantRequest.ReadOnly {
    override val snapshotCopyGrantName: String =
      impl.snapshotCopyGrantName(): String
    override val kmsKeyId: Option[String] =
      scala.Option(impl.kmsKeyId()).map(value => value: String)
    override val tags: Option[List[zio.aws.redshift.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.redshift.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.redshift.model.CreateSnapshotCopyGrantRequest
  ): zio.aws.redshift.model.CreateSnapshotCopyGrantRequest.ReadOnly =
    new Wrapper(impl)
}
