package zio.aws.rdsdata.model
import zio.aws.rdsdata.model.primitives.{DbName, Arn}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BeginTransactionRequest(
    resourceArn: Arn,
    secretArn: Arn,
    database: Optional[DbName] = Optional.Absent,
    schema: Optional[DbName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest = {
    import BeginTransactionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .secretArn(Arn.unwrap(secretArn): java.lang.String)
      .optionallyWith(
        database.map(value => DbName.unwrap(value): java.lang.String)
      )(_.database)
      .optionallyWith(
        schema.map(value => DbName.unwrap(value): java.lang.String)
      )(_.schema)
      .build()
  }
  def asReadOnly: zio.aws.rdsdata.model.BeginTransactionRequest.ReadOnly =
    zio.aws.rdsdata.model.BeginTransactionRequest.wrap(buildAwsValue())
}
object BeginTransactionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rdsdata.model.BeginTransactionRequest =
      zio.aws.rdsdata.model.BeginTransactionRequest(
        resourceArn,
        secretArn,
        database.map(value => value),
        schema.map(value => value)
      )
    def resourceArn: Arn
    def secretArn: Arn
    def database: Optional[DbName]
    def schema: Optional[DbName]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getSecretArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(secretArn)
    def getDatabase: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("database", database)
    def getSchema: ZIO[Any, AwsError, DbName] =
      AwsError.unwrapOptionField("schema", schema)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
  ) extends zio.aws.rdsdata.model.BeginTransactionRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.resourceArn())
    override val secretArn: Arn =
      zio.aws.rdsdata.model.primitives.Arn(impl.secretArn())
    override val database: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.database())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
    override val schema: Optional[DbName] = zio.aws.core.internal
      .optionalFromNullable(impl.schema())
      .map(value => zio.aws.rdsdata.model.primitives.DbName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rdsdata.model.BeginTransactionRequest
  ): zio.aws.rdsdata.model.BeginTransactionRequest.ReadOnly = new Wrapper(impl)
}
