package zio.aws.rdsdata.model
import scala.jdk.CollectionConverters.*
sealed trait DecimalReturnType {
  def unwrap: software.amazon.awssdk.services.rdsdata.model.DecimalReturnType
}
object DecimalReturnType {
  def wrap(
      value: software.amazon.awssdk.services.rdsdata.model.DecimalReturnType
  ): zio.aws.rdsdata.model.DecimalReturnType = value match {
    case software.amazon.awssdk.services.rdsdata.model.DecimalReturnType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rdsdata.model.DecimalReturnType.STRING =>
      val r = STRING
      r
    case software.amazon.awssdk.services.rdsdata.model.DecimalReturnType.DOUBLE_OR_LONG =>
      val r = DOUBLE_OR_LONG
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.rdsdata.model.DecimalReturnType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.DecimalReturnType =
      software.amazon.awssdk.services.rdsdata.model.DecimalReturnType.UNKNOWN_TO_SDK_VERSION
  }
  case object STRING extends zio.aws.rdsdata.model.DecimalReturnType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.DecimalReturnType =
      software.amazon.awssdk.services.rdsdata.model.DecimalReturnType.STRING
  }
  case object DOUBLE_OR_LONG extends zio.aws.rdsdata.model.DecimalReturnType {
    override def unwrap
        : software.amazon.awssdk.services.rdsdata.model.DecimalReturnType =
      software.amazon.awssdk.services.rdsdata.model.DecimalReturnType.DOUBLE_OR_LONG
  }
}
